/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class HackableEnderman
implements IHackableEntity {
    private static final ResourceLocation ID = PneumaticRegistry.RL("enderman");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    public boolean canHack(Entity entity, Player player) {
        return entity instanceof EnderMan && HackableEnderman.canEndermanTeleport((LivingEntity)((EnderMan)entity));
    }

    @Override
    public void addHackInfo(Entity entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.stopTeleport", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Entity entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.stopTeleporting", new Object[0]));
    }

    @Override
    public int getHackTime(Entity entity, Player player) {
        return 60;
    }

    @Override
    public void onHackFinished(Entity entity, Player player) {
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return entity.m_6084_();
    }

    private static boolean canEndermanTeleport(LivingEntity entity) {
        List<IHackableEntity> hacks = CommonArmorRegistry.getInstance().getCurrentEntityHacks((Entity)entity);
        return hacks.stream().noneMatch(hack -> hack instanceof HackableEnderman);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onEnderTeleport(EntityTeleportEvent.EnderEntity event) {
            LivingEntity e = event.getEntityLiving();
            if (e instanceof EnderMan && !HackableEnderman.canEndermanTeleport(e)) {
                event.setCanceled(true);
            }
        }
    }
}

